<?php

namespace App\Models\Keywords;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Keyword extends Model 
{

    protected $table = 'keywords';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('verified');

    public function getQuizes()
    {
        return $this->belongsToMany('Quiz', 'quiz_keyword');
    }

    public function getChallenges()
    {
        return $this->belongsToMany('Challenge', 'challenge_keywords');
    }

    public function getEventFacts()
    {
        return $this->belongsToMany('Events', 'event_facts_keyword');
    }

    public function getActivities()
    {
        return $this->belongsToMany('Activity', 'activity_keyword');
    }

}